using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// XML parse-related exceptions that may occur in VistALink code.
	/// </summary>
	public class XmlParseException : FlatMediumParseException
	{
		/// <summary>
		/// Default parameterless constructor. Should be avoided whenever possible.
		/// </summary>
		public XmlParseException() 
			: base() {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public XmlParseException( string message )
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public XmlParseException( string message, Exception innerException )
			: base( message, innerException ) {}
	}
}
